package net.leanix.dropkit.k8s;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;

public class KubernetesConfiguration {

    @NotNull
    private Boolean enabled = false;

    @JsonProperty("role")
    private String roles = "";

    public boolean isEnabled() {
        return enabled;
    }

    public boolean isJobsPod() {
        return getRoles().contains(KubernetesRole.JOBS);
    }

    public Collection<KubernetesRole> getRoles() {
        return Stream.of(roles.split(","))
            .peek(e -> System.out.println(e))
            .filter(role -> role.length() > 0)
            .map(role -> KubernetesRole.fromString(role))
            .collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public enum KubernetesRole {
        JOBS("jobs"), SERVER("server");

        private final String nameInConfig;

        private KubernetesRole(String nameInConfig) {
            this.nameInConfig = nameInConfig;
        }

        public static KubernetesRole fromString(String input) {
            for (KubernetesRole role : values()) {
                if (role.nameInConfig.equalsIgnoreCase(input)) {
                    return role;
                }
            }
            throw new IllegalArgumentException("Unable to create Role from string: " + input);
        }

    }
}
