/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestUtil.class);
    private static final String META_INF_MANIFEST_MF = "META-INF/MANIFEST.MF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Optional<Manifest> findManifestForJar(String bootJarName) {
        Optional<Manifest> optional;
        Throwable throwable;
        InputStream is;
        InputStream firstApproachManifestIS;
        block19: {
            block20: {
                ArrayList<Object> resouresList;
                block18: {
                    Object nextElement;
                    firstApproachManifestIS = null;
                    Enumeration<URL> resources = this.getClass().getClassLoader().getResources(META_INF_MANIFEST_MF);
                    resouresList = new ArrayList<Object>();
                    while (resources.hasMoreElements()) {
                        nextElement = resources.nextElement();
                        resouresList.add(nextElement);
                    }
                    if (!resouresList.isEmpty()) break block18;
                    nextElement = Optional.empty();
                    IOUtils.closeQuietly(firstApproachManifestIS);
                    return nextElement;
                }
                Collections.reverse(resouresList);
                URL relevantUrl = resouresList.stream().peek(url -> LOG.debug("found: {}", url)).filter(url -> url.toString().contains(bootJarName)).findFirst().orElse((URL)resouresList.get(0));
                is = relevantUrl.openStream();
                throwable = null;
                LOG.info("parsing manifest from url '{}'", (Object)relevantUrl);
                optional = Optional.of(new Manifest(is));
                if (is == null) break block19;
                if (throwable == null) break block20;
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block19;
            }
            is.close();
        }
        IOUtils.closeQuietly(firstApproachManifestIS);
        return optional;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("failed to load resource '{}' for boot jar '{}'", new Object[]{META_INF_MANIFEST_MF, bootJarName, e});
                        IOUtils.closeQuietly(firstApproachManifestIS);
                    }
                }
                catch (Throwable throwable6) {
                    IOUtils.closeQuietly(firstApproachManifestIS);
                    throw throwable6;
                }
            }
        }
        return Optional.empty();
    }

    public static ManifestGauge createManifestGauge(Manifest manifest) {
        return new ManifestGauge(manifest);
    }

    public static class ManifestGauge
    implements MetricSet {
        private final Manifest manifest;

        ManifestGauge(Manifest manifest) {
            this.manifest = manifest;
        }

        public Map<String, Metric> getMetrics() {
            HashMap<String, Object> gauges = new HashMap<String, Object>();
            gauges.put("version", new Gauge<String>(){

                public String getValue() {
                    return this.readFromManifest("Implementation-Version");
                }
            });
            gauges.put("title", new Gauge<String>(){

                public String getValue() {
                    return this.readFromManifest("Implementation-Title");
                }
            });
            return Collections.unmodifiableMap(gauges);
        }

        protected String readFromManifest(String name) {
            Attributes attributes = this.manifest.getMainAttributes();
            String value = "---";
            if (attributes != null) {
                value = attributes.getValue(name);
            }
            return value;
        }
    }
}

