package net.leanix.dropkit.oauth.jwks;

import io.jsonwebtoken.Jwts;

import net.leanix.dropkit.oauth.token.OAuth2TokenParserBase;
import net.leanix.dropkit.oauth.models.User;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

public class OAuth2TokenParserJWKS<U extends User> extends OAuth2TokenParserBase {

    public OAuth2TokenParserJWKS(OAuth2TokenConfig config) {
        super(
                Jwts.parser().setSigningKeyResolver(
                        new SigningKeyResolverJWKS(config)
                )
        );
    }
}