/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import net.leanix.dropkit.oauth.token.ConfigException;
import net.leanix.dropkit.oauth.token.KeyReaderRSA;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

public class OAuth2AuthServerConfig
implements OAuth2TokenConfig {
    @JsonProperty
    private String privateKeyPath;

    public String getPrivateKeyPath() {
        return this.privateKeyPath;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    @Override
    @JsonIgnore
    public Key getSigningKey() throws ConfigException {
        if (this.privateKeyPath == null) {
            throw new ConfigException("SigningKeyPath must be set", null);
        }
        try {
            return KeyReaderRSA.getPrivateKey(this.privateKeyPath);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConfigException(null, e);
        }
    }
}

