package net.leanix.dropkit.util;

public enum DeploymentColor {

    GREEN("green"), BLUE("blue"), WHITE("white");

    private final String color;

    private DeploymentColor(String color) {
        this.color = color;
    }

    public String getColor() {
        return color;
    }

    public static DeploymentColor fromString(String currentColor) {
        if (currentColor != null) {
            for (DeploymentColor b : DeploymentColor.values()) {
                if (currentColor.equalsIgnoreCase(b.color)) {
                    return b;
                }
            }
        }
        return null;
    }
}
