package net.leanix.dropkit.etcd;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.IOException;

public final class EtcdException extends IOException {

    private static final long serialVersionUID = 1L;

    private final int errorCode;
    private final long index;
    private final String key;

    public EtcdException(
        final int errorCode,
        final String etcdCause,
        final String etcdMessage,
        final long index,
        final String key,
        final Throwable cause) {

        super(etcdMessage + " (cause: " + etcdCause + ')', cause);

        this.errorCode = errorCode;
        this.index = index;
        this.key = key;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public long getIndex() {
        return index;
    }

    public String getKey() {
        return key;
    }
}
