package net.leanix.dropkit.amqp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.rabbitmq.client.ConnectionFactory;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

/**
 * Configuration.
 *
 * @link https://github.com/aruld/dropwizard-amqp-sample
 */
public class AMQPConfiguration {

    /**
     * Shared topic exchange.
     */
    @JsonProperty
    private String exchange = "";

    /**
     * The server-side consumer's queue that provides point-to-point semantics
     * for stock requests.
     */
    @JsonProperty
    private String queueBase = "net.leanix.queue";
    
    @JsonProperty
    private String queueSuffix = "white";

    @NotEmpty
    @JsonProperty
    private String host;

    @Min(1)
    @Max(65535)
    @JsonProperty
    private int port = ConnectionFactory.DEFAULT_AMQP_PORT;

    @NotEmpty
    @JsonProperty
    private String username = ConnectionFactory.DEFAULT_USER;

    @NotEmpty
    @JsonProperty
    private String password = ConnectionFactory.DEFAULT_PASS;

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public String getExchange() {
        return exchange;
    }

    public String getQueueBase() {
        return queueBase;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public void setQueueBase(String queue) {
        this.queueBase = queue;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQueueSuffix() {
        return queueSuffix;
    }

    public void setQueueSuffix(String queueSuffix) {
        this.queueSuffix = queueSuffix;
    }
    
    public String getQueue() {
        return this.queueBase + "." + this.queueSuffix;
    }
}
