/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.api;

import java.util.HashMap;
import java.util.Map;
import net.leanix.dropkit.api.Payload;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class PayloadTest {
    @Test
    public void fromObject() {
        TestObject test = new TestObject();
        test.something = "A String";
        Payload p = Payload.fromObject((Object)test);
        Assertions.assertThat((Object)p.getKey("something")).isEqualTo((Object)"A String");
    }

    @Test
    public void fromString() {
        Payload p = Payload.fromString((String)"{\"something\": \"A String\"}");
        Assertions.assertThat((Object)p.getKey("something")).isEqualTo((Object)"A String");
    }

    @Test
    public void testToString() {
        Payload p = new Payload();
        p.setKey("a", (Object)"b");
        Assertions.assertThat((String)p.toString()).isEqualTo((Object)"{\"a\":\"b\"}");
    }

    @Test
    public void toMap() {
        Payload p = new Payload();
        p.setKey("a", (Object)"b");
        Assertions.assertThat((Map)p.toMap()).isInstanceOf(HashMap.class);
        Assertions.assertThat((boolean)p.toMap().containsKey("a")).isTrue();
    }

    class TestObject {
        public String something;

        TestObject() {
        }
    }
}

