package net.leanix.dropkit.responses;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import java.util.List;

/**
 * A generic entity container for api responses providing lists.
 *
 *
 *
 * @param <Serializable>
 * @deprecated
 */
@JsonInclude(Include.NON_NULL)
public abstract class ListResponse<Serializable> extends BasicResponse {

    protected List<Serializable> data;

    public ListResponse() {
        super();
    }

    public ListResponse(List<Serializable> entities) {
        super();
        status = ResponseStatus.OK;
        data = entities;
        if (entities.size() > 0) {
            type = entities.get(0).getClass().getSimpleName();
        }
    }

    @JsonInclude
    public abstract List<Serializable> getData();

    public void setData(List<Serializable> data) {
        this.data = data;
    }
}
