package net.leanix.dropkit.oauth.models;

import java.util.ArrayList;
import java.util.List;

/**
 * User roles on account level.
 *
 *
 */
public enum UserRole {

    SUPERADMIN, //this should not be applied to regular users
    SYSTEM, //a system user for application instances,
    APICLIENT,
    ACCOUNTADMIN,
    ACCOUNTUSER;

    public static List<String> asStringList() {
        List<String> strings = new ArrayList<>();
        for (UserRole r : values()) {
            strings.add(r.toString());
        }
        return strings;
    }
}
