package net.leanix.dropkit.etcd;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public final class EtcdResponse {

    private final String action;
    private final Node node;

    /******* fields only used in case of errors **********/
    public Node prevNode;
    public int errorCode;
    public String message;
    public String cause;
    public int index;

    public EtcdResponse(
        @JsonProperty("action") final String action,
        @JsonProperty("node") final Node node) {
        this.action = action;
        this.node = node;
    }

    public String getAction() {
        return action;
    }

    public Node getNode() {
        return node;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Node {
        private final String key;
        private final String value;
        private final long createdIndex;
        private final long modifiedIndex;
        private final long ttl;
        private final List<Node> nodes;

        public Node(@JsonProperty("key") final String key,
            @JsonProperty("value") final String value,
            @JsonProperty("createdIndex") final long createdIndex,
            @JsonProperty("modifiedIndex") final long modifiedIndex,
            @JsonProperty("ttl") final long ttl,
            @JsonProperty("nodes") final List<Node> nodes) {

            this.key = key;
            this.value = value;
            this.createdIndex = createdIndex;
            this.modifiedIndex = modifiedIndex;
            this.ttl = ttl;
            this.nodes = nodes;
        }

        public String getKey() {
            return key;
        }

        public long getCreatedIndex() {
            return createdIndex;
        }

        public long getModifiedIndex() {
            return modifiedIndex;
        }

        public long getTtl() {
            return ttl;
        }

        public String getValue() {
            return value;
        }

        public List<Node> getNodes() {
            return nodes;
        }
    }
}
