package net.leanix.dropkit;

import javax.ws.rs.core.Response;

/**
 * Convenience class to avoid boilerplate code, allows sending an error message.
 *
 *
 *
 */
public class WebApplicationException extends javax.ws.rs.WebApplicationException {

    public static javax.ws.rs.WebApplicationException withMessage(Response.Status status, String errorMessage) {
        Response response = Response.status(status).entity(errorMessage).build();
        return new javax.ws.rs.WebApplicationException(response);
    }

    public static javax.ws.rs.WebApplicationException withPayload(Response.Status status, Object o) {
        Response response = Response.status(status).entity(o).build();
        return new javax.ws.rs.WebApplicationException(response);
    }
}
