package net.leanix.dropkit;

import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.leanix.dropkit.responses.BasicResponse;

/**
 *
 * @link http://stackoverflow.com/questions/24573028/dropwizard-custom-exception-for-invalidentityexception
 */
@Provider
public class InvalidEntityMapper implements ExceptionMapper<ConstraintViolationException> {

    /**
     *
     * @param ex
     * @return
     */
    @Override
    public Response toResponse(ConstraintViolationException ex) {
        return Response.status(422)
                .entity(new BasicResponse(ex))
                .type("text/json")
                .build();
    }
}
