/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Stopwatch {
    private final String id;
    private boolean keepTaskList = true;
    private final List<TaskInfo> taskList = new LinkedList<TaskInfo>();
    private long startTimeMillis;
    private boolean running;
    private String currentTaskName;
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeMillis;

    public Stopwatch() {
        this("");
    }

    public Stopwatch(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setKeepTaskList(boolean keepTaskList) {
        this.keepTaskList = keepTaskList;
    }

    public void start() throws IllegalStateException {
        this.start("", new Object[0]);
    }

    public void start(String taskName, Object ... args) throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.running = true;
        this.currentTaskName = args.length > 0 ? String.format(taskName, args) : taskName;
        this.startTimeMillis = System.currentTimeMillis();
    }

    public void flip(String taskName, Object ... args) {
        this.stop();
        if (args.length > 0) {
            this.start(String.format(taskName, args), new Object[0]);
        } else {
            this.start(taskName, new Object[0]);
        }
    }

    public void stop() throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long lastTime = System.currentTimeMillis() - this.startTimeMillis;
        this.totalTimeMillis += lastTime;
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, lastTime);
        if (this.keepTaskList) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.running = false;
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String currentTaskName() {
        return this.currentTaskName;
    }

    public long getLastTaskTimeMillis() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task interval");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public String getLastTaskName() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task name");
        }
        return this.lastTaskInfo.getTaskName();
    }

    public TaskInfo getLastTaskInfo() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tasks run: can't get last task info");
        }
        return this.lastTaskInfo;
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public double getTotalTimeSeconds() {
        return (double)this.totalTimeMillis / 1000.0;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        if (!this.keepTaskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[this.taskList.size()]);
    }

    public String shortSummary() {
        return "StopWatch '" + this.getId() + "': running time (millis) = " + this.getTotalTimeMillis();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        sb.append('\n');
        if (!this.keepTaskList) {
            sb.append("No task info kept");
        } else {
            sb.append("-----------------------------------------\n");
            sb.append("ms     %     Task name\n");
            sb.append("-----------------------------------------\n");
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setGroupingUsed(false);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMinimumIntegerDigits(3);
            pf.setGroupingUsed(false);
            for (TaskInfo task : this.getTaskInfo()) {
                sb.append(nf.format(task.getTimeMillis())).append("  ");
                if (this.getTotalTimeSeconds() == 0.0) {
                    sb.append("-  ");
                } else {
                    sb.append(pf.format(task.getTimeSeconds() / this.getTotalTimeSeconds())).append("  ");
                }
                sb.append(this.getId()).append("::").append(task.getTaskName()).append("\n");
            }
        }
        return sb.toString();
    }

    public String prettyPrintAggregations() {
        Map<String, List<TaskInfo>> groupedTaskInfo = Arrays.stream(this.getTaskInfo()).collect(Collectors.groupingBy(TaskInfo::getTaskName));
        StringBuilder sb = new StringBuilder(this.shortSummary());
        sb.append('\n');
        if (!this.keepTaskList) {
            sb.append("No task info kept");
        } else {
            sb.append("-----------------------------------------\n");
            sb.append("ms     %     #   Task name\n");
            sb.append("-----------------------------------------\n");
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setGroupingUsed(false);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMinimumIntegerDigits(3);
            pf.setGroupingUsed(false);
            Comparator<String> byDurationMs = Comparator.comparingLong(task -> this.sumTimeMillis((List)groupedTaskInfo.get(task)));
            groupedTaskInfo.keySet().stream().sorted(byDurationMs.reversed()).forEach(taskName -> {
                List tasks = (List)groupedTaskInfo.get(taskName);
                long sumMillis = this.sumTimeMillis(tasks);
                double sumSecs = tasks.stream().mapToDouble(t -> t.getTimeSeconds()).sum();
                sb.append(nf.format(sumMillis)).append("  ");
                if (this.getTotalTimeSeconds() == 0.0) {
                    sb.append("-  ");
                } else {
                    sb.append(pf.format(sumSecs / this.getTotalTimeSeconds())).append("  ");
                }
                sb.append(tasks.size() + "x").append("  ");
                sb.append(this.getId()).append("::").append((String)taskName).append("\n");
            });
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        if (this.keepTaskList) {
            for (TaskInfo task : this.getTaskInfo()) {
                sb.append("; [").append(task.getTaskName()).append("] took ").append(task.getTimeMillis());
                long percent = Math.round(100.0 * task.getTimeSeconds() / this.getTotalTimeSeconds());
                sb.append(" = ").append(percent).append("%");
            }
        } else {
            sb.append("; no task info kept");
        }
        return sb.toString();
    }

    private long sumTimeMillis(List<TaskInfo> tasks) {
        return tasks.stream().mapToLong(t -> t.getTimeMillis()).sum();
    }

    public static final class TaskInfo {
        private final String taskName;
        private final long timeMillis;

        TaskInfo(String taskName, long timeMillis) {
            this.taskName = taskName;
            this.timeMillis = timeMillis;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeMillis() {
            return this.timeMillis;
        }

        public double getTimeSeconds() {
            return (double)this.timeMillis / 1000.0;
        }
    }
}

