/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import com.google.common.hash.HashCode;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtil {
    static final String HASH_ALGORITHM = "SHA-512";
    private static final byte[] SALT = "44j6VBhUTV6eWYT5BPYkwBuRFD6aXqr8".getBytes();

    private HashUtil() {
    }

    public static String hash(String input) {
        if (input == null) {
            return input;
        }
        if ((input = input.trim()).isEmpty()) {
            return input;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
            messageDigest.update(SALT);
            byte[] hash = messageDigest.digest(input.getBytes(StandardCharsets.UTF_8));
            return HashCode.fromBytes((byte[])hash).toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return input;
        }
    }

    static {
        try {
            MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

