/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutExecutor.class);
    private final long timeout;
    private final long sleeping;

    public TimeoutExecutor(long timeout, long sleeping) {
        this.timeout = timeout;
        this.sleeping = sleeping;
    }

    public boolean checkUntilConditionIsTrue(Callable<Boolean> callable) {
        long end = System.currentTimeMillis() + this.timeout;
        try {
            while (System.currentTimeMillis() < end) {
                if (callable.call().booleanValue()) {
                    return true;
                }
                Thread.sleep(this.sleeping);
            }
            LOG.warn("Skip condition testing due to timeout!");
        }
        catch (InterruptedException e) {
            LOG.warn("stop checking conditions", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Got exception during checking the condition.", (Throwable)e);
        }
        return false;
    }

    public <T> T callUntilReturnIsNotNull(Callable<T> callable) {
        long end = System.currentTimeMillis() + this.timeout;
        try {
            while (System.currentTimeMillis() < end) {
                T result = callable.call();
                if (result != null) {
                    return result;
                }
                Thread.sleep(this.sleeping);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("stop checking conditions", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Got exception during checking the condition.", (Throwable)e);
        }
        return null;
    }
}

