/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.nio.charset.Charset;
import net.leanix.dropkit.amqp.ConsumerRegistry;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueueConsumer
extends DefaultConsumer {
    private final Logger log = LoggerFactory.getLogger(QueueConsumer.class);
    private final String queueName;
    private final ConsumerRegistry registry;
    private String registeredConsumerTag;
    private volatile boolean unregistering = false;
    private volatile long lastUsed;
    private final Charset utf8 = Charset.forName("UTF-8");

    public abstract void simpleHandle(String var1) throws IOException;

    public QueueConsumer(String queueName, Channel channel, ConsumerRegistry registry) {
        super(channel);
        this.queueName = queueName;
        this.registry = registry;
        this.lastUsed = System.currentTimeMillis();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getRegisteredConsumerTag() {
        return this.registeredConsumerTag;
    }

    public void setRegisteredConsumerTag(String consumerTag) {
        this.registeredConsumerTag = consumerTag;
    }

    public void setUnregistering() {
        this.unregistering = true;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void handleDelivery(String consumerTag, Envelope env, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.log.debug("received message {} from queue {}", (Object)props.getMessageId(), (Object)this.queueName);
        this.lastUsed = System.currentTimeMillis();
        String stringBody = new String(body, this.utf8);
        long startTime = System.currentTimeMillis();
        try {
            this.simpleHandle(stringBody);
        }
        catch (JsonMappingException e) {
            this.log.warn("can not handle message: {}", (Object)stringBody);
        }
        long duration = System.currentTimeMillis() - startTime;
        this.log.debug("finished message in time: {}", (Object)DurationFormatUtils.formatDurationWords((long)duration, (boolean)true, (boolean)false));
        try {
            this.getChannel().basicAck(env.getDeliveryTag(), false);
        }
        catch (AlreadyClosedException e) {
            if (duration >= 120000L) {
                this.log.info("Received expected exception {} during long processing message, which takes: {}", (Object)((Object)((Object)e)).getClass().getSimpleName(), (Object)DurationFormatUtils.formatDurationWords((long)duration, (boolean)true, (boolean)false));
            }
            throw e;
        }
    }

    public void handleConsumeOk(String consumerTag) {
        this.log.info("consumer started consuming for queue {}, consumerTag={}", (Object)this.queueName, (Object)consumerTag);
    }

    public void handleCancelOk(String consumerTag) {
        this.log.info("consumer for queue {}, consumerTag={}, was regularly cancelled. unregister it.", (Object)this.queueName, (Object)consumerTag);
        if (!this.unregistering) {
            this.unregistering = true;
            this.registry.unregister(this);
        }
    }

    public void handleCancel(String consumerTag) {
        this.log.info("consumer for queue {}, consumerTag={}, was cancelled, e.g. because queue was deleted. unregister it.", (Object)this.queueName, (Object)consumerTag);
        if (!this.unregistering) {
            this.unregistering = true;
            this.registry.unregister(this);
        }
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException e) {
        this.log.info("{} for consumer for queue {}, consumerTag={}, was closed. unregister consumer.", new Object[]{e.isHardError() ? "connection" : "channel", this.queueName, consumerTag});
        if (!this.unregistering) {
            this.unregistering = true;
            this.registry.unregister(this);
        }
    }
}

