package net.leanix.dropkit.util.k8s;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.NotNull;

public class ContainerK8sConfiguration {

    @NotNull
    @JsonProperty("enabled")
    private boolean runsInKubernetes = false;

    @JsonProperty("role")
    private String appRole = ContainerRole.SERVER.toString();

    public boolean isRunningInKubernetes() {
        return runsInKubernetes;
    }

    public boolean isServer() {
        return ContainerRole.fromString(appRole) == ContainerRole.SERVER;
    }

    public boolean isJobsPod() {
        return ContainerRole.fromString(appRole) == ContainerRole.JOBS;
    }

    public boolean isMigration() {
        return ContainerRole.fromString(appRole) == ContainerRole.MIGRATION;
    }

    public boolean isKubernetesJobExecutionEnabled() {
        return isRunningInKubernetes() && isJobsPod();
    }
}
