/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RetryExecutor.class);
    private final ScheduledExecutorService scheduleExecutorService;
    private final int delayAfterFail;
    private final TimeUnit delayAfterFailUnit;

    public RetryExecutor() {
        this(1, 2, TimeUnit.SECONDS, "RetryExecutor-%d");
    }

    public RetryExecutor(int corePoolSize, int delayAfterFail, TimeUnit delayAfterFailUnit, String patternThreadFactory) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(patternThreadFactory).setDaemon(true).build();
        this.scheduleExecutorService = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        this.delayAfterFail = delayAfterFail;
        this.delayAfterFailUnit = delayAfterFailUnit;
    }

    public void stop() throws InterruptedException {
        LOG.info("stopping scheduleExecutorService");
        this.scheduleExecutorService.shutdownNow();
        this.scheduleExecutorService.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public void run(RetryTask task) {
        this.submitInternal(new AtomicInteger(0), task, 0L, TimeUnit.MILLISECONDS);
    }

    private <V> void submitInternal(AtomicInteger callCount, RetryTask task, long delay, TimeUnit delayTimeUnit) {
        this.scheduleExecutorService.schedule(() -> {
            try {
                task.call(callCount.get());
            }
            catch (Throwable e) {
                LOG.debug("runnable ({}) throws exception, restart runnable again", (Object)callCount.get(), (Object)e);
                callCount.incrementAndGet();
                this.submitInternal(callCount, task, this.delayAfterFail, this.delayAfterFailUnit);
            }
        }, delay, delayTimeUnit);
    }

    @FunctionalInterface
    public static interface RetryTask {
        public void call(int var1) throws Exception;
    }
}

