package net.leanix.dropkit;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;

import net.leanix.dropkit.oauth.CrossOriginConfig;
import net.leanix.dropkit.oauth.OAuth2ResourceServerConfig;

/**
 * This configuration is to be used by microservices, which want to
 * authenticate incoming requests, e.g. webhooks
 */
public class ConfigurationResourceServer extends Configuration {
    protected OAuth2ResourceServerConfig oauth = new OAuth2ResourceServerConfig();
    protected CrossOriginConfig cors;

    /**
     * Returns the necessary configuration to run oauth resource providers.
     *
     * Values can be empty.
     *
     * @return
     */
    @JsonProperty("oauth")
    public OAuth2ResourceServerConfig getOAuth2TokenConfig() {
        return oauth;
    }

    @JsonProperty("oauth")
    public void setOAuth2TokenConfig(OAuth2ResourceServerConfig config) {
        this.oauth = config;
    }

    @JsonProperty("cors")
    public CrossOriginConfig getCrossOriginConfig() {
        return cors;
    }

    @JsonProperty("cors")
    public void setCrossOriginConfig(CrossOriginConfig cors) {
        this.cors = cors;
    }

}
