package net.leanix.dropkit.oauth;

import net.leanix.dropkit.oauth.token.ConfigException;
import net.leanix.dropkit.oauth.token.KeyReaderRSA;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;

public class OAuth2ResourceServerConfig implements OAuth2TokenConfig {

    @JsonProperty
    private String publicKeyPath;

    public String getPublicKeyPath() {
        return publicKeyPath;
    }

    public void setPublicKeyPath(String publicKeyPath) {
        this.publicKeyPath = publicKeyPath;
    }

    @Override
    @JsonIgnore
    public Key getSigningKey() throws ConfigException {
        if (this.publicKeyPath == null)
            throw new ConfigException("SigningKeyPath must be set", null);

        try {
            return KeyReaderRSA.getPublicKey(this.publicKeyPath);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ConfigException(null, e);
        }
    }
}
