/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchPathUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SearchPathUtil.class);

    public static InputStream openStream(String ... paths) throws FileNotFoundException {
        for (String path : paths) {
            if (path.startsWith("classpath:")) {
                String resourceName = path.substring(10);
                InputStream stream = SearchPathUtil.class.getResourceAsStream(resourceName);
                if (stream != null) {
                    LOG.info("Reading from " + path);
                    return stream;
                }
            } else {
                File file = new File(path);
                if (file.exists()) {
                    LOG.info("Reading from " + path);
                    return new FileInputStream(file);
                }
            }
            LOG.debug("Not found: " + path);
        }
        throw new FileNotFoundException("Could not find resource at the following locations: " + Arrays.asList(paths));
    }

    public static byte[] getBytes(String ... paths) throws IOException {
        InputStream inputStream = SearchPathUtil.openStream(paths);
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (IOException e) {
            LOG.error("Can not read from resource '" + Arrays.asList(paths) + "'.", (Throwable)e);
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findPath(String ... paths) {
        for (String path : paths) {
            if (path.startsWith("classpath:")) {
                String resourceName = path.substring(10);
                InputStream stream = SearchPathUtil.class.getResourceAsStream(resourceName);
                try {
                    if (stream == null) continue;
                    String string = path;
                    return string;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            if (!new File(path).exists()) continue;
            return path;
        }
        throw new IllegalArgumentException("File not found in " + Arrays.asList(paths));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String ... path) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = SearchPathUtil.openStream(path);
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static File[] listFiles(File dir, final String wildcardMatcher) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean matches = true;
                if (wildcardMatcher != null) {
                    matches = FilenameUtils.wildcardMatch((String)name, (String)wildcardMatcher);
                }
                if (matches) {
                    return !SearchPathUtil.isTempSystemFile(name);
                }
                return matches;
            }
        });
    }

    public static boolean isTempSystemFile(String fileName) {
        return fileName.equals(".DS_Store");
    }
}

