package net.leanix.dropkit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

/**
 * Helper class to to determine which profile or profiles are set to current running application.
 * 
 * @author ralfwehner
 *
 */
public class DeploymentProfileHelper {

    public static final String TEST = "test";
    public static final String ON_PREMISE = "on-premise";

    public static List<String> getProfiles() {
        String profiles = System.getenv("PROFILE");
        profiles = System.getProperty("PROFILE", profiles);
        if (StringUtils.isEmpty(profiles)) {
            return new ArrayList<>();
        }
        return Arrays.asList(StringUtils.split(profiles, ','));
    }

    public static boolean hasProfile(String str) {
        for (String profile : getProfiles()) {
            if (str.equalsIgnoreCase(profile)) {
                return true;
            }
        }
        return false;
    }

}
