/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.leanix.dropkit.etcd.EtcdException;
import net.leanix.dropkit.etcd.MinimalEtcdClient;
import net.leanix.dropkit.etcd.MinimalEtcdClientFactory;
import net.leanix.dropkit.util.DeploymentColor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentUtil.class);
    static String ROOT_VHOSTS = "/vhosts/";
    public static final String VIRTUAL_HOST = "VIRTUAL_HOST";
    public static final String CONTAINER_COLOR = "CONTAINER_COLOR";
    public static final String ETCD_SERVER = "ETCD_SERVER";
    private final MinimalEtcdClient etcdClient;
    private final DeploymentColor containerColor;

    public DeploymentUtil(MinimalEtcdClientFactory etcdClientFactory) {
        URI etcdUri;
        String color = this.getEnvironmentVariable(CONTAINER_COLOR);
        this.containerColor = DeploymentColor.fromString(color);
        LOG.debug("Detected assigned deployment color '{}' for this container.", (Object)this.containerColor);
        String etcdServer = this.getEnvironmentVariable(ETCD_SERVER);
        if (StringUtils.isEmpty((CharSequence)etcdServer)) {
            LOG.debug("No etcd server configuration detected. Is this container running in an on premise environment? ETCD configuration will be skipped.");
            etcdUri = null;
        } else {
            etcdUri = URI.create(String.format("http://%s", etcdServer));
        }
        this.etcdClient = etcdUri != null ? etcdClientFactory.create(etcdUri) : null;
    }

    public DeploymentUtil() {
        this(new MinimalEtcdClientFactory());
    }

    public DeploymentColor getContainerColor() {
        return this.containerColor;
    }

    public DeploymentColor getContainerColorOrDefault(DeploymentColor defaultColor) {
        Preconditions.checkNotNull((Object)((Object)defaultColor), (Object)"defaultColor must not be null");
        return this.getContainerColor() != null ? this.getContainerColor() : defaultColor;
    }

    public boolean isInstanceCurrentlyActive() {
        if (this.containerColor == null) {
            LOG.warn("Can not detect container color and return: NO - this container is not currently active.");
            return false;
        }
        if (this.containerColor == DeploymentColor.WHITE) {
            return true;
        }
        if (this.etcdClient == null) {
            if (this.containerColor != DeploymentColor.WHITE) {
                LOG.warn("Although the container color '{}' is specified, no environment variable '{}' exists to specify the etcd configuration.", (Object)this.containerColor, (Object)ETCD_SERVER);
            }
            return true;
        }
        try {
            String currentColor = this.retrieveEtcdValue("deploy_current");
            LOG.debug("Read current deployment color '{}' from etcd. This container has color {}.", (Object)currentColor, (Object)this.containerColor);
            return this.containerColor.toString().equalsIgnoreCase(currentColor);
        }
        catch (EtcdException e) {
            LOG.warn("Problem accessing etcd (URL is '{}')", (Object)this.etcdClient.getEtcdUri(), (Object)e);
            return false;
        }
    }

    private String getEnvironmentVariable(String varName) {
        String env = System.getenv(varName);
        if (env == null) {
            LOG.debug("Environment variable '{}' not found in Sytem.env(). Try to read from System.properties.", (Object)varName);
            return System.getProperty(varName);
        }
        return env;
    }

    public String retrieveEtcdValue(String key) throws EtcdException {
        String completeKey = this.buildKeyForVirtualHost(key);
        if (this.etcdClient == null) {
            LOG.info("Can not read etcd key '{}' because no etcd server was configured before.", (Object)completeKey);
            return null;
        }
        String value = this.etcdClient.get(completeKey);
        LOG.debug("Retrieved value '{}' under key '{}' from etcd. (URL: {})", new Object[]{value, completeKey, this.etcdClient.getEtcdUri()});
        return value;
    }

    public void writeEtcdValue(String key, String value) throws EtcdException {
        String completeKey = this.buildKeyForVirtualHost(key);
        if (this.etcdClient == null) {
            LOG.info("Can not write etcd value '{}' to '{}' because no etcd server was configured before.", (Object)value, (Object)completeKey);
            return;
        }
        this.etcdClient.set(completeKey, value);
        LOG.debug("Set value '{}' under key '{}' in etcd. (URL: {})", new Object[]{value, completeKey, this.etcdClient.getEtcdUri()});
    }

    public boolean writeEtcdValueIfNeeded(String key, String value) throws EtcdException {
        String curValue = this.retrieveEtcdValue(key);
        if (!StringUtils.equals((CharSequence)value, (CharSequence)curValue)) {
            this.writeEtcdValue(key, value);
            LOG.info("Updated key '{}' with value '{}' in etcd.", (Object)key, (Object)value);
            return true;
        }
        return false;
    }

    public List<String> listEtcdKey(String key) throws EtcdException {
        String completeKey = this.buildKeyForVirtualHost(key);
        if (this.etcdClient == null) {
            LOG.info("Can not list etcd key '{}' because no etcd server was configured before.", (Object)completeKey);
            return null;
        }
        List<String> originalValues = this.etcdClient.list(completeKey);
        String replacement = this.buildKeyForVirtualHost("");
        ArrayList<String> values = new ArrayList<String>();
        for (String path : originalValues) {
            values.add(path.replace(replacement, ""));
        }
        return values;
    }

    public void deleteEtcdKey(String key, boolean recursive) throws EtcdException {
        String completeKey = this.buildKeyForVirtualHost(key);
        if (this.etcdClient == null) {
            LOG.info("Can not delete etcd key '{}' because no etcd server was configured before.", (Object)completeKey);
            return;
        }
        this.etcdClient.delete(completeKey, recursive);
    }

    public boolean deleteEtcdKeyIfNeeded(String key, boolean recursive) throws EtcdException {
        String completeKey = this.buildKeyForVirtualHost(key);
        if (this.etcdClient == null) {
            LOG.info("Can not delete etcd key '{}' because no etcd server was configured before.", (Object)completeKey);
            return false;
        }
        if (this.etcdClient.exists(completeKey)) {
            this.deleteEtcdKey(key, recursive);
            LOG.info("Deleted key '{}' from etcd.", (Object)key);
            return true;
        }
        return false;
    }

    public String getVirtualHost() {
        return this.getEnvironmentVariable(VIRTUAL_HOST);
    }

    public String buildKeyForVirtualHost(String key) {
        String virtualHost = this.getVirtualHost();
        if (StringUtils.isEmpty((CharSequence)virtualHost)) {
            virtualHost = "local-svc.leanix.net";
            LOG.warn("Environment variable '{}' not found. Using '{}' as default.", (Object)VIRTUAL_HOST, (Object)virtualHost);
        }
        String completeKey = ROOT_VHOSTS + virtualHost.trim() + '/' + key;
        return completeKey;
    }

    public MinimalEtcdClient getEtcdClient() {
        return this.etcdClient;
    }

    public boolean isEtcdConfigured() {
        return this.etcdClient != null && this.etcdClient.getEtcdUri() != null;
    }
}

