/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.testutil.etcdclient;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import net.leanix.dropkit.etcd.EtcdException;
import net.leanix.dropkit.etcd.EtcdResponse;
import net.leanix.dropkit.testutil.etcdclient.EtcdApi;
import net.leanix.dropkit.testutil.etcdclient.EtcdClient;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class EtcdClientImpl
implements EtcdClient {
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final EtcdApi etcd;

    public EtcdClientImpl(Optional<OkHttpClient> okClient, URI serverUrl) {
        Retrofit.Builder retrofit = new Retrofit.Builder().baseUrl(serverUrl.toString()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper));
        if (okClient.isPresent()) {
            retrofit.client(okClient.get());
        }
        this.etcd = (EtcdApi)retrofit.build().create(EtcdApi.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String version() throws EtcdException, IOException {
        Response execute = this.etcd.version().execute();
        InputStream is = ((ResponseBody)execute.body()).byteStream();
        try (InputStreamReader reader = new InputStreamReader(is, Charsets.UTF_8);){
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
        catch (IOException e) {
            return "ERROR: " + e.getMessage();
        }
    }

    @Override
    public String get(String key) throws EtcdException, IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        return ((EtcdResponse)this.etcd.get(key).execute().body()).getNode().getValue();
    }

    @Override
    public void set(String key, String value) throws EtcdException, IOException {
        Response response;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0);
        String setKey = key;
        if (key.startsWith("/")) {
            setKey = key.substring(1);
        }
        if (!(response = this.etcd.set(setKey, value, null, null, null).execute()).isSuccessful()) {
            throw EtcdClientImpl.createEtcdException((Response<EtcdResponse>)response);
        }
    }

    @Override
    public void set(String key, String value, int ttl) throws EtcdException, IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0);
        Preconditions.checkArgument((ttl > 0 ? 1 : 0) != 0);
        Response response = this.etcd.set(key, value, ttl, null, null).execute();
        if (!response.isSuccessful()) {
            throw EtcdClientImpl.createEtcdException((Response<EtcdResponse>)response);
        }
    }

    @Override
    public void createDir(String dir) throws EtcdException, IOException {
        Response response;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dir) ? 1 : 0) != 0);
        String setKey = dir;
        if (dir.startsWith("/")) {
            setKey = dir.substring(1);
        }
        if (!(response = this.etcd.set(setKey, null, null, true, null).execute()).isSuccessful()) {
            throw EtcdClientImpl.createEtcdException((Response<EtcdResponse>)response);
        }
    }

    @Override
    public void delete(String key) throws EtcdException, IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        Response response = this.etcd.delete(key).execute();
        if (!response.isSuccessful()) {
            throw EtcdClientImpl.createEtcdException((Response<EtcdResponse>)response);
        }
    }

    @Override
    public Map<String, String> list(String path) throws EtcdException, IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EtcdResponse.Node node : ((EtcdResponse)this.etcd.get(path).execute().body()).getNode().getNodes()) {
            builder.put((Object)node.getKey(), (Object)node.getValue());
        }
        return builder.build();
    }

    @Override
    public void compareAndSwap(String key, String oldValue, String newValue) throws EtcdException, IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)oldValue) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)newValue) ? 1 : 0) != 0);
        Preconditions.checkArgument((!oldValue.equals(newValue) ? 1 : 0) != 0);
        EtcdResponse response = (EtcdResponse)this.etcd.set(key, newValue, null, null, oldValue).execute().body();
        response.getNode().getValue();
    }

    public static EtcdException createEtcdException(Response<EtcdResponse> response) {
        EtcdResponse body = (EtcdResponse)response.body();
        if (body != null) {
            return new EtcdException(body.errorCode, body.cause, body.message, (long)body.index, null, null);
        }
        return new EtcdException(response.code(), null, response.message(), -1L, null, null);
    }
}

