/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit;

import com.codahale.metrics.MetricFilter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.Charsets;
import com.palominolabs.metrics.newrelic.AllEnabledMetricAttributeFilter;
import com.palominolabs.metrics.newrelic.MetricAttributeFilter;
import com.palominolabs.metrics.newrelic.NewRelicReporter;
import io.dropwizard.Configuration;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.text.DateFormat;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import net.leanix.dropkit.BusinessLogicExceptionMapper;
import net.leanix.dropkit.InvalidEntityMapper;
import net.leanix.dropkit.swagger.ApiDocsAssetServlet;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.eclipse.jetty.servlets.CrossOriginFilter;

public class AppHelper {
    public void initializeISO8601(Bootstrap<? extends Configuration> bootstrap) {
        bootstrap.getObjectMapper().registerModule((Module)new JodaModule());
        bootstrap.getObjectMapper().setDateFormat((DateFormat)new ISO8601DateFormat());
    }

    public void initialize(Bootstrap<? extends Configuration> bootstrap) {
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StrSubstitutor)new EnvironmentVariableSubstitutor(false)));
        this.initializeISO8601(bootstrap);
    }

    public void run(Configuration config, Environment environment) {
        this.addCORSFilter(environment);
        this.registerExceptionMappers(environment);
        this.registerNewRelicReporter(environment);
    }

    public void runSwagger(Configuration config, Environment environment) {
        new AssetsBundle("/swagger", "/docs", "index.html", "swagger").run(environment);
        environment.servlets().addServlet("api-docs", (Servlet)new ApiDocsAssetServlet("/swagger-assets", "/api-docs", "swagger.json", Charsets.UTF_8, "configureMeIfNeeded")).addMapping(new String[]{"/api-docs/*"});
    }

    public void registerExceptionMappers(Environment environment) {
        environment.jersey().register((Object)new InvalidEntityMapper());
        environment.jersey().register((Object)new BusinessLogicExceptionMapper());
    }

    public void registerNewRelicReporter(Environment environment) {
        NewRelicReporter reporter = new NewRelicReporter(environment.metrics(), "NewRelic reporter", MetricFilter.ALL, (MetricAttributeFilter)new AllEnabledMetricAttributeFilter(), TimeUnit.SECONDS, TimeUnit.MILLISECONDS, "");
        reporter.start(1L, TimeUnit.MINUTES);
    }

    public void addCORSFilter(Environment environment) {
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("Access-Control-Allow-Origin", "*");
        filter.setInitParameter("allowedHeaders", "accept,accept-encoding,accept-language,access-control-request-headers,access-control-request-method,api-key,authorization,cache-control,content-type,content-length,connection,host,pragma,referer,x-requested-with,origin,x-api-sync-mode,x-api-key,x-credentials");
        filter.setInitParameter("allowedMethods", "GET,PUT,POST,DELETE,OPTIONS");
        filter.setInitParameter("preflightMaxAge", "5184000");
        filter.setInitParameter("allowCredentials", "true");
    }
}

