package net.leanix.dropkit.oauth.token;

import net.leanix.dropkit.oauth.models.Principal;

import java.util.Date;
import java.util.UUID;

public class OAuth2Token {
    private UUID id;
    private Principal principal;
    private Date expiration;
    private String refreshToken;
    private Date refreshExpiration;

    public UUID getId() {
        return id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Principal getPrincipal() {
        return principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public Date getExpiration() {
        return expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public boolean isExpired() {
        if (this.expiration == null)
            throw new RuntimeException("No expiration has been set");

        Date now = new Date();
        return now.compareTo(this.expiration) >= 0;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Date getRefreshExpiration() {
        return refreshExpiration;
    }

    public void setRefreshExpiration(Date refreshExpiration) {
        this.refreshExpiration = refreshExpiration;
    }
}
