package net.leanix.dropkit.etcd;

import java.net.URI;
import java.util.List;

public interface MinimalEtcdClient {

    /**
     * Retrieve the value of the given key, if set.
     *
     * @param key Key to look up
     * @return value Value for the given key
     * @throws EtcdException in case of an error (e.g. key doesn't exist)
     */
    String get(String key) throws EtcdException;

    /**
     * Set a value under the given key.
     * @param key
     * @param value
     * @return
     * @throws EtcdException
     */
    void set(String key, String value) throws EtcdException;

    void delete(String key, boolean recursive) throws EtcdException;

    List<String> list(String key) throws EtcdException;

    URI getEtcdUri();
}
