/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.etcd;

import java.net.URI;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.leanix.dropkit.etcd.EtcdException;
import net.leanix.dropkit.etcd.EtcdResponse;
import net.leanix.dropkit.etcd.MinimalEtcdClient;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalEtcdClientImpl
implements MinimalEtcdClient {
    private final Logger LOG = LoggerFactory.getLogger(MinimalEtcdClientImpl.class);
    private final Client client;
    private final URI etcdUri;

    public MinimalEtcdClientImpl(URI etcdUri) {
        this.etcdUri = etcdUri;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.readTimeout", (Object)120000);
        clientConfig.property("jersey.config.client.connectTimeout", (Object)10000);
        this.client = ClientBuilder.newClient((Configuration)clientConfig);
    }

    @Override
    public URI getEtcdUri() {
        return this.etcdUri;
    }

    @Override
    public String get(String key) throws EtcdException {
        WebTarget webTarget = this.client.target(this.etcdUri).path("v2/keys").path(key);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        try {
            Response response = invocationBuilder.get();
            if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                throw new EtcdException(1, null, String.format("can not read key '%s' from etcd uri '%s'. Status code: %s", key, this.etcdUri, response.getStatus()), 1L, key, null);
            }
            EtcdResponse result = (EtcdResponse)response.readEntity(EtcdResponse.class);
            return result.errorCode == 100 ? null : result.getNode().getValue();
        }
        catch (ProcessingException e) {
            throw new EtcdException(1, null, String.format("can not read key '%s' from etcd uri '%s'.", key, this.etcdUri), 1L, key, e);
        }
    }

    @Override
    public void set(String key, String value) throws EtcdException {
        WebTarget webTarget = this.client.target(this.etcdUri).path("v2/keys").path(key);
        Form form = new Form();
        form.param("value", value);
        Invocation.Builder invocationBuilder = webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        try {
            Response response = invocationBuilder.put(Entity.entity((Object)form, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL && response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                this.LOG.warn("Error while putting value '{}' to key '{}' on etcd. Status code: {}", new Object[]{value, key, response.getStatus()});
                throw new EtcdException(1, response.getEntity().toString(), "received HTTP " + response.getStatus(), 1L, key, null);
            }
        }
        catch (ProcessingException e) {
            this.LOG.warn("Error while getting '{}' key on etcd with uri '{}'", (Object)key, (Object)this.etcdUri);
            throw new EtcdException(1, null, String.format("can not read key '%s' from etcd uri '%s'.", key, this.etcdUri), 1L, key, e);
        }
    }
}

