/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.leanix.dropkit.etcd.EtcdException;
import net.leanix.dropkit.testutil.etcdclient.EtcdClient;
import net.leanix.dropkit.testutil.etcdclient.EtcdClientImpl;
import net.leanix.dropkit.util.DeploymentColor;
import net.leanix.dropkit.util.DeploymentUtil;
import net.leanix.dropkit.util.NetworkUtils;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUtilTestEtcd4j {
    private static Logger LOG = LoggerFactory.getLogger(DeploymentUtilTestEtcd4j.class);
    private static final String VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT = "/vhosts_junit/local-svc.leanix.net/deploy_current";
    private static URI ETCD_URI;
    private static EtcdClient client;

    @BeforeClass
    public static void beforeClass() {
        ETCD_URI = NetworkUtils.getFirstReachableAddress(URI.create("http://192.168.99.100:4001/"), URI.create("http://192.168.59.103:4001/"));
        Assume.assumeTrue((ETCD_URI != null ? 1 : 0) != 0);
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient okClient = new OkHttpClient.Builder().connectTimeout(15L, TimeUnit.SECONDS).addNetworkInterceptor((Interceptor)httpLoggingInterceptor).build();
        client = new EtcdClientImpl(Optional.of(okClient), ETCD_URI);
        try {
            client.createDir(FilenameUtils.getPath((String)VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Before
    public void setup() throws IOException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.setProperty("CONTAINER_COLOR", "Green");
        System.setProperty("ETCD_SERVER", ETCD_URI.getHost() + ":" + ETCD_URI.getPort());
        DeploymentUtil.ROOT_VHOSTS = "/vhosts_junit/";
        try {
            LOG.trace("Delete key '{}'", (Object)VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT);
            client.delete(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT);
        }
        catch (EtcdException etcdException) {
            // empty catch block
        }
    }

    @Test
    public void testVersion() throws EtcdException, IOException {
        String version = client.version();
        Assertions.assertThat((String)version).isNotEmpty();
        Assertions.assertThat((String)version.toUpperCase()).doesNotContain((CharSequence)"ERROR");
        System.out.println("Found etcd version: " + version);
    }

    @Test
    public void test_getContainerColor_not_specified() {
        System.clearProperty("CONTAINER_COLOR");
        System.clearProperty("ETCD_SERVER");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((Comparable)deploymentUtil.getContainerColor()).isNull();
    }

    @Test
    public void test_getContainerColor_withColor() {
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((Comparable)deploymentUtil.getContainerColor()).isEqualTo((Object)DeploymentColor.GREEN);
    }

    @Test
    public void test_getContainerColor_illegalColorName() {
        System.setProperty("CONTAINER_COLOR", "yellow");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((Comparable)deploymentUtil.getContainerColor()).isNull();
    }

    @Test
    public void test_isInstanceCurrentlyActive_Etcd_not_reachable_no_containerColor() {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.setProperty("ETCD_SERVER", "localhost:5000");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    private boolean isEtcdRunning() {
        try {
            String version = client.version();
            return StringUtils.isNotEmpty((CharSequence)version);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Test
    public void test_isInstanceCurrentlyActive_Etcd_not_reachable_withContainerColor() {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.setProperty("ETCD_SERVER", "localhost:5000");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    @Test
    public void test_isInstanceCurrentlyActive_Etcd_not_reachable_butContainerColorWhite() {
        System.setProperty("ETCD_SERVER", "localhost:5000");
        System.setProperty("CONTAINER_COLOR", "white");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isTrue();
    }

    @Test
    public void test_isInstanceCurrentlyActive_no_ETCD_SERVER_specified() throws IOException, EtcdException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.clearProperty("ETCD_SERVER");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isTrue();
    }

    @Test
    public void test_isInstanceCurrentlyActive_no_DeployCurrent_specified_in_etcd() throws EtcdException, IOException, InterruptedException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        try {
            client.delete(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    @Test
    public void test_isInstanceCurrentlyActive_no_containerColor() throws IOException, EtcdException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.clearProperty("CONTAINER_COLOR");
        client.set(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT, "green");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    @Test
    public void test_isInstanceCurrentlyActive_identicalContainerColor() throws IOException, EtcdException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        client.set(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT, "green");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isTrue();
    }

    @Test
    public void test_isInstanceCurrentlyActive_differentContainerColor() throws IOException, EtcdException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        client.set(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT, "blue");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    @Test(timeout=2000L)
    public void test_isInstanceCurrentlyActive_specifying_VIRTUAL_HOST() throws IOException, EtcdException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.setProperty("VIRTUAL_HOST", "junitTestHost");
        client.set(DeploymentUtil.ROOT_VHOSTS + "junitTestHost/deploy_current", "green");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isTrue();
    }
}

