/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.swing.UnsupportedLookAndFeelException;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import net.leanix.dropkit.BusinessLogicException;
import net.leanix.dropkit.api.ApiError;
import net.leanix.dropkit.responses.BasicResponse;
import net.leanix.dropkit.responses.ResponseStatus;
import net.leanix.dropkit.responses.TestModel;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class BasicResponseTest {
    @Test
    public void containsTheErrorsAsMap() throws JsonProcessingException {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        String msgTxt = "msgtext";
        ConstraintViolationException ex = new ConstraintViolationException(msgTxt, validator.validate((Object)new TestModel(), new Class[0]));
        BasicResponse response = new BasicResponse(ex);
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)ResponseStatus.ERROR);
        Assertions.assertThat((Long)response.getTotal()).isEqualTo(0L);
        Assertions.assertThat((String)response.getType()).isEqualTo((Object)"ConstraintViolationException");
        Assertions.assertThat((String)response.getMessage()).isEqualTo((Object)msgTxt);
        List errors = response.getErrors();
        Assertions.assertThat((Object)response.getError("id")).isNotNull();
        Assertions.assertThat((Object)response.getError("id")).isInstanceOf(ApiError.class);
        ObjectMapper mapper = new ObjectMapper();
        Assertions.assertThat((String)mapper.writeValueAsString((Object)response)).contains(new CharSequence[]{"\"errors\":[{\"value\":\"id\",\"messages\":["});
    }

    @Test
    public void returnsZeroIfTotalIsNull() {
        BasicResponse res = new BasicResponse();
        Assertions.assertThat((Long)res.getTotal()).isEqualTo(0L);
    }

    @Test
    public void messageTextIsPropagated1() {
        String msgtxt = "msgtxt";
        BusinessLogicException ex = new BusinessLogicException(msgtxt);
        BasicResponse response = new BasicResponse(ex);
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)ResponseStatus.ERROR);
        Assertions.assertThat((Long)response.getTotal()).isEqualTo(0L);
        Assertions.assertThat((String)response.getType()).isEqualTo((Object)"BusinessLogicException");
        Assertions.assertThat((String)response.getMessage()).isEqualTo((Object)msgtxt);
        List errors = response.getErrors();
        Assertions.assertThat((List)errors).hasSize(1);
        Assertions.assertThat((String)((ApiError)errors.get(0)).getValue()).isEqualTo((Object)"error");
        Assertions.assertThat((List)((ApiError)errors.get(0)).getMessages()).hasSize(1);
        Assertions.assertThat((String)((String)((ApiError)errors.get(0)).getMessages().get(0))).isEqualTo((Object)msgtxt);
    }

    @Test
    public void messageTextIsPropagated2() {
        String msgtxt = "msgtxt";
        BusinessLogicException ex = new BusinessLogicException(msgtxt, 555);
        BasicResponse response = new BasicResponse(ex);
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)ResponseStatus.ERROR);
        Assertions.assertThat((Long)response.getTotal()).isEqualTo(0L);
        Assertions.assertThat((String)response.getType()).isEqualTo((Object)"BusinessLogicException");
        Assertions.assertThat((String)response.getMessage()).isEqualTo((Object)msgtxt);
        List errors = response.getErrors();
        Assertions.assertThat((List)errors).hasSize(1);
        Assertions.assertThat((String)((ApiError)errors.get(0)).getValue()).isEqualTo((Object)"error");
        Assertions.assertThat((List)((ApiError)errors.get(0)).getMessages()).hasSize(1);
        Assertions.assertThat((String)((String)((ApiError)errors.get(0)).getMessages().get(0))).isEqualTo((Object)msgtxt);
    }

    @Test
    public void messageTextIsPropagated13() {
        String msgtxt = "msgtxt";
        BusinessLogicException ex = new BusinessLogicException(msgtxt, (Throwable)new UnsupportedLookAndFeelException("i'm feeling uncomftbel"));
        BasicResponse response = new BasicResponse(ex);
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)ResponseStatus.ERROR);
        Assertions.assertThat((Long)response.getTotal()).isEqualTo(0L);
        Assertions.assertThat((String)response.getType()).isEqualTo((Object)"BusinessLogicException");
        Assertions.assertThat((String)response.getMessage()).isEqualTo((Object)msgtxt);
        List errors = response.getErrors();
        Assertions.assertThat((List)errors).hasSize(1);
        Assertions.assertThat((String)((ApiError)errors.get(0)).getValue()).isEqualTo((Object)"error");
        Assertions.assertThat((List)((ApiError)errors.get(0)).getMessages()).hasSize(1);
        Assertions.assertThat((String)((String)((ApiError)errors.get(0)).getMessages().get(0))).isEqualTo((Object)msgtxt);
    }

    @Test
    public void fieldNameAndmessageTextIsPropagated() {
        String blub = "blub";
        String blubber = "blubber";
        BusinessLogicException ex = new BusinessLogicException(blub, blubber);
        BasicResponse response = new BasicResponse(ex);
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)ResponseStatus.ERROR);
        Assertions.assertThat((Long)response.getTotal()).isEqualTo(0L);
        Assertions.assertThat((String)response.getType()).isEqualTo((Object)"BusinessLogicException");
        Assertions.assertThat((String)response.getMessage()).isEqualTo((Object)"error for property");
        List errors = response.getErrors();
        Assertions.assertThat((List)errors).hasSize(1);
        Assertions.assertThat((String)((ApiError)errors.get(0)).getValue()).isEqualTo((Object)blub);
        Assertions.assertThat((List)((ApiError)errors.get(0)).getMessages()).hasSize(1);
        Assertions.assertThat((String)((String)((ApiError)errors.get(0)).getMessages().get(0))).isEqualTo((Object)blubber);
    }
}

