/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.quartz;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.leanix.dropkit.quartz.SimpleManagedJobScheduler;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;

public class SimpleManagedJobSchedulerTest {
    private static CountDownLatch executionIsRunning;
    private static long jobsProcessingDuration;
    private static long jobsExecuteCounter;
    private static long jobsFinishedCounter;
    private SimpleManagedJobScheduler jobScheduler;

    @Before
    public void setup() throws Exception {
        executionIsRunning = new CountDownLatch(1);
        jobsExecuteCounter = 0L;
        jobsFinishedCounter = 0L;
        this.jobScheduler = SimpleManagedJobScheduler.getInstance();
        this.jobScheduler.start();
    }

    @After
    public void tearDown() throws Exception {
        this.jobScheduler.stop();
    }

    @Test
    public void test_addJob_with_DisallowConcurrentExecution() throws SchedulerException, InterruptedException {
        executionIsRunning = new CountDownLatch(2);
        jobsProcessingDuration = 250L;
        this.jobScheduler.addJob(DisallowConcurrentExecutionTestJob.class, 100L);
        executionIsRunning.await(10L, TimeUnit.SECONDS);
        Assertions.assertThat((long)jobsFinishedCounter).isEqualTo(2L);
        System.out.println(String.format("Job has been running %d time(s).", jobsExecuteCounter));
    }

    @Test
    public void test_addJob_without_DisallowConcurrentExecution() throws SchedulerException, InterruptedException {
        executionIsRunning = new CountDownLatch(2);
        jobsProcessingDuration = 250L;
        this.jobScheduler.addJob(TestJob.class, 100L);
        executionIsRunning.await(10L, TimeUnit.SECONDS);
        System.out.println(String.format("Job has been running %d time(s).", jobsExecuteCounter));
        Assertions.assertThat((long)jobsExecuteCounter).isGreaterThan(2L);
    }

    static {
        jobsProcessingDuration = 0L;
    }

    @DisallowConcurrentExecution
    public static class DisallowConcurrentExecutionTestJob
    extends TestJob {
    }

    public static class TestJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            System.out.println(" Job's execute() is startet...");
            jobsExecuteCounter++;
            try {
                Thread.sleep(jobsProcessingDuration);
            }
            catch (InterruptedException e) {
                System.out.println("Job's execute() is interrupted!");
            }
            System.out.println(" Job's execute() is finished.");
            jobsFinishedCounter++;
            executionIsRunning.countDown();
        }
    }
}

