package net.leanix.dropkit.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;

/**
 * A hateoas link.
 *
 *
 */
public class Link {

    @JsonIgnore
    public final String SELF = "self";

    private String rel;
    private String href;

    public Link() {

    }

    public Link(String rel, URI uri) {
        this.rel = rel;
        href = uri.toASCIIString();
    }

    public String getRel() {
        return rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

}
