/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import mousio.client.retry.RetryNTimes;
import mousio.client.retry.RetryPolicy;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.responses.EtcdAuthenticationException;
import mousio.etcd4j.responses.EtcdException;
import net.leanix.dropkit.util.DeploymentColor;
import net.leanix.dropkit.util.DeploymentUtil;
import net.leanix.dropkit.util.NetworkUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUtilTestEtcd4j {
    private static Logger LOG = LoggerFactory.getLogger(DeploymentUtilTestEtcd4j.class);
    private static final String VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT = "/vhosts_junit/local-svc.leanix.net/deploy_current";
    private static URI ETCD_URI;

    @BeforeClass
    public static void beforeClass() {
        ETCD_URI = NetworkUtils.getFirstReachableAddress(URI.create("http://192.168.99.100:4001/"), URI.create("http://192.168.59.103:4001/"));
    }

    @Before
    public void setup() throws IOException, EtcdAuthenticationException, TimeoutException {
        System.setProperty("CONTAINER_COLOR", "Green");
        System.setProperty("ETCD_SERVER", ETCD_URI.getHost() + ":" + ETCD_URI.getPort());
        DeploymentUtil.ROOT_VHOSTS = "/vhosts_junit/";
        try (EtcdClient client = new EtcdClient(new URI[]{ETCD_URI});){
            LOG.trace("Delete key '{}'", (Object)VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT);
            client.delete(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT).setRetryPolicy((RetryPolicy)new RetryNTimes(300, 1)).send().get();
        }
        catch (EtcdException etcdException) {
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    @Test
    public void test_getContainerColor_not_specified() {
        System.clearProperty("CONTAINER_COLOR");
        System.clearProperty("ETCD_SERVER");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((Comparable)deploymentUtil.getContainerColor()).isNull();
    }

    @Test
    public void test_getContainerColor_withColor() {
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((Comparable)deploymentUtil.getContainerColor()).isEqualTo((Object)DeploymentColor.GREEN);
    }

    @Test
    public void test_getContainerColor_illegalColorName() {
        System.setProperty("CONTAINER_COLOR", "yellow");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((Comparable)deploymentUtil.getContainerColor()).isNull();
    }

    @Test
    public void test_isInstanceCurrentlyActive_Etcd_not_reachable_no_containerColor() {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.setProperty("ETCD_SERVER", "localhost:5000");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEtcdRunning() {
        try (EtcdClient client = new EtcdClient(new URI[]{ETCD_URI});){
            client.put(DeploymentUtil.ROOT_VHOSTS + "junitTestHost/test_running", "jo").send().get();
            boolean bl = true;
            return bl;
        }
        catch (IOException | TimeoutException | EtcdAuthenticationException | EtcdException e) {
            return false;
        }
    }

    @Test
    public void test_isInstanceCurrentlyActive_Etcd_not_reachable_withContainerColor() {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.setProperty("ETCD_SERVER", "localhost:5000");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    @Test
    public void test_isInstanceCurrentlyActive_Etcd_not_reachable_butContainerColorWhite() {
        System.setProperty("ETCD_SERVER", "localhost:5000");
        System.setProperty("CONTAINER_COLOR", "white");
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isTrue();
    }

    @Test
    public void test_isInstanceCurrentlyActive_no_ETCD_SERVER_specified() throws IOException, EtcdException, EtcdAuthenticationException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.clearProperty("ETCD_SERVER");
        try (EtcdClient client = new EtcdClient(new URI[]{ETCD_URI});){
            client.setRetryHandler((RetryPolicy)new RetryNTimes(300, 1));
            client.put(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT, "green").send().get();
        }
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isTrue();
    }

    @Test
    public void test_isInstanceCurrentlyActive_no_DeployCurrent_specified_in_etcd() {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    @Test
    public void test_isInstanceCurrentlyActive_no_containerColor() throws IOException, EtcdException, EtcdAuthenticationException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.clearProperty("CONTAINER_COLOR");
        try (EtcdClient client = new EtcdClient(new URI[]{ETCD_URI});){
            client.put(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT, "green").send().get();
        }
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    @Test
    public void test_isInstanceCurrentlyActive_identicalContainerColor() throws IOException, EtcdException, EtcdAuthenticationException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        try (EtcdClient client = new EtcdClient(new URI[]{ETCD_URI});){
            client.put(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT, "green").send().get();
        }
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isTrue();
    }

    @Test
    public void test_isInstanceCurrentlyActive_differentContainerColor() throws IOException, EtcdException, EtcdAuthenticationException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        try (EtcdClient client = new EtcdClient(new URI[]{ETCD_URI});){
            client.put(VHOSTS_LOCAL_SVC_LEANIX_NET_DEPLOY_CURRENT, "blue").send().get();
        }
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isFalse();
    }

    @Test(timeout=2000L)
    public void test_isInstanceCurrentlyActive_specifying_VIRTUAL_HOST() throws IOException, EtcdException, EtcdAuthenticationException, TimeoutException {
        Assume.assumeTrue((boolean)this.isEtcdRunning());
        System.setProperty("VIRTUAL_HOST", "junitTestHost");
        try (EtcdClient client = new EtcdClient(new URI[]{ETCD_URI});){
            client.put(DeploymentUtil.ROOT_VHOSTS + "junitTestHost/deploy_current", "green").send().get();
        }
        DeploymentUtil deploymentUtil = new DeploymentUtil();
        Assertions.assertThat((boolean)deploymentUtil.isInstanceCurrentlyActive()).isTrue();
    }
}

