package net.leanix.dropkit.oauth.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.UUID;


/**
 * Permission for a user to access a workspace.
 *
 * Defaults to active contact.
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Permission implements Serializable {

    private static final long serialVersionUID = 1L;
    
    private UUID id;
    private UUID workspaceId;
    private PermissionRole role;
    private PermissionStatus status = PermissionStatus.ACTIVE;

    public Permission() {
    }

    public void setId(UUID id) {
        this.id = id;
    }

    @ApiModelProperty(dataType = "string")
    public UUID getId() {
        return id;
    }

    @ApiModelProperty(dataType = "string")
    public UUID getWorkspaceId() {
        return workspaceId;
    }

    public void setWorkspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
    }

    @ApiModelProperty(dataType = "string")
    public PermissionStatus getStatus() {
        return status;
    }

    public void setStatus(PermissionStatus status) {
        this.status = status;
    }

    @JsonIgnore
    public boolean isActive() {
        return PermissionStatus.ACTIVE.equals(status);
    }

    @JsonIgnore
    public boolean isActive(PermissionRole role) {
        return isActive() && hasRole(role);
    }

    @ApiModelProperty(dataType = "string")
    public PermissionRole getRole() {
        return role;
    }

    public void setRole(PermissionRole role) {
        this.role = role;
    }

    /**
     * Checks if the permission has the given role.
     *
     * @param role
     * @return
     */
    public boolean hasRole(PermissionRole role) {
        return this.role != null && this.role.equals(role);
    }

    @Override
    public String toString() {
        return "[Permission: Workspace " + workspaceId + ", role " + role + ", status " + status.toString() + "]";
    }
}
