/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import mousio.client.retry.RetryNTimes;
import mousio.client.retry.RetryPolicy;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.responses.EtcdAuthenticationException;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import net.leanix.dropkit.util.DeploymentColor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUtil {
    static String ROOT_VHOSTS = "/vhosts/";
    public static final String VIRTUAL_HOST = "VIRTUAL_HOST";
    public static final String CONTAINER_COLOR = "CONTAINER_COLOR";
    public static final String ETCD_SERVER = "ETCD_SERVER";
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentUtil.class);
    private final DeploymentColor containerColor;
    final URI etcdUri;

    public DeploymentUtil() {
        String color = this.getEnvironmentVariable(CONTAINER_COLOR);
        this.containerColor = DeploymentColor.fromString(color);
        LOG.debug("Detected assigned deployment color '{}' for this container.", (Object)this.containerColor);
        String etcdServer = this.getEnvironmentVariable(ETCD_SERVER);
        if (StringUtils.isEmpty((CharSequence)etcdServer)) {
            LOG.debug("No etcd server configuration detected. Is this container running in an on premise environment? ETCD configuration will be skipped.");
            this.etcdUri = null;
        } else {
            this.etcdUri = URI.create(String.format("http://%s", etcdServer));
        }
    }

    public DeploymentColor getContainerColor() {
        return this.containerColor;
    }

    public DeploymentColor getContainerColorOrDefault(DeploymentColor defaultColor) {
        Preconditions.checkNotNull((Object)((Object)defaultColor), (Object)"defaultColor must not be null");
        return this.getContainerColor() != null ? this.getContainerColor() : defaultColor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInstanceCurrentlyActive() {
        if (this.containerColor == null) {
            LOG.warn("Can not detect container color and return: NO - this container is not currently active.");
            return false;
        }
        if (this.containerColor == DeploymentColor.WHITE) {
            return true;
        }
        if (this.etcdUri == null) {
            if (this.containerColor == DeploymentColor.WHITE) return true;
            LOG.warn("Althought the container color '{}' is specified, no environment variable '{}' exists to specify the etcd configuration.", (Object)this.containerColor, (Object)ETCD_SERVER);
            return true;
        }
        String virtualHost = this.getEnvironmentVariable(VIRTUAL_HOST);
        if (StringUtils.isEmpty((CharSequence)virtualHost)) {
            virtualHost = "local-svc.leanix.net";
            LOG.warn("Environment variable '{}' not found. Using '{}' as default.", (Object)VIRTUAL_HOST, (Object)virtualHost);
        }
        String key = ROOT_VHOSTS + virtualHost.trim() + "/deploy_current";
        try (EtcdClient client = new EtcdClient(new URI[]{this.etcdUri});){
            LOG.trace("Using key '{}', container color is: {}", (Object)key, (Object)this.containerColor);
            EtcdResponsePromise promise = client.get(key).setRetryPolicy((RetryPolicy)new RetryNTimes(300, 2)).send();
            EtcdKeysResponse etcdKeysResponse = (EtcdKeysResponse)promise.get();
            String currentColor = etcdKeysResponse.node.value;
            LOG.debug("Read current deployment color '{}' from etcd. This container has color {}. (URL: {}, key: '{}')", new Object[]{currentColor, this.containerColor, this.etcdUri, key});
            boolean bl = this.containerColor.toString().equalsIgnoreCase(currentColor);
            return bl;
        }
        catch (IOException | TimeoutException | EtcdAuthenticationException e) {
            LOG.warn("Internal error: Can not connect to etcd server! (URL: " + this.etcdUri + ")", e);
            return false;
        }
        catch (EtcdException e) {
            LOG.warn("Problem accessing etcd key '{}', URL is '{}', msg: {}", new Object[]{key, this.etcdUri, e.getMessage()});
        }
        return false;
    }

    private String getEnvironmentVariable(String varName) {
        String env = System.getenv(varName);
        if (env == null) {
            LOG.debug("Environment varible '{}' not found in Sytem.env(). Try to read from system.properties.", (Object)varName);
            return System.getProperty(varName);
        }
        return env;
    }
}

