/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.util.Date;
import java.util.UUID;
import net.leanix.dropkit.oauth.models.User;
import net.leanix.dropkit.oauth.token.ConfigException;
import net.leanix.dropkit.oauth.token.OAuth2Token;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2TokenParser {
    private static final Logger log = LoggerFactory.getLogger(OAuth2TokenParser.class);
    OAuth2TokenConfig config;
    Key key;

    public OAuth2TokenParser(OAuth2TokenConfig config) throws ConfigException {
        this.config = config;
        this.key = config.getSigningKey();
    }

    public OAuth2Token parse(String accessToken) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.key).parseClaimsJws(accessToken).getBody();
        ObjectMapper mapper = new ObjectMapper();
        User user = (User)mapper.convertValue(claims.get((Object)"principal"), User.class);
        OAuth2Token token = new OAuth2Token();
        if (claims.getId() != null) {
            token.setId(UUID.fromString(claims.getId()));
        } else {
            log.error("no jti claim in JWT! Why? This is safe, and should disappear once all old JWT have expired");
        }
        token.setPrincipal(user);
        user.setAccessToken(accessToken);
        token.setExpiration(claims.getExpiration());
        if (claims.get((Object)"refresh_token") != null) {
            token.setRefreshToken((String)claims.get("refresh_token", String.class));
        }
        if (claims.get((Object)"refresh_expiration") != null) {
            token.setRefreshExpiration((Date)claims.get("refresh_exp", Date.class));
        }
        return token;
    }
}

