package net.leanix.dropkit.oauth.token;

import net.leanix.dropkit.oauth.models.User;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;

import java.security.Key;
import java.util.Date;
import java.util.UUID;

public class OAuth2TokenParser {
    OAuth2TokenConfig config;
    Key key;

    public OAuth2TokenParser(OAuth2TokenConfig config) throws ConfigException {
        this.config = config;
        this.key = config.getSigningKey();
    }

    /**
     * Parse a Jwt and return OAuth2Token
     *
     * @param accessToken
     * @return
     */
    public OAuth2Token parse(String accessToken) {
        Claims claims = Jwts.parser().setSigningKey(this.key).parseClaimsJws(accessToken).getBody();

        ObjectMapper mapper = new ObjectMapper();
        User user = mapper.convertValue(claims.get("principal"), User.class);

        OAuth2Token token = new OAuth2Token();
        token.setId(UUID.fromString(claims.getId()));
        token.setPrincipal(user);
        user.setAccessToken(accessToken);
        token.setExpiration(claims.getExpiration());

        if (claims.get("refresh_token") != null) {
            token.setRefreshToken(claims.get("refresh_token", String.class));
        }

        if (claims.get("refresh_expiration") != null) {
            token.setRefreshExpiration(claims.get("refresh_exp", Date.class));
        }

        return token;
    }
}
