package net.leanix.dropkit;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.leanix.dropkit.responses.BasicResponse;
import org.slf4j.LoggerFactory;

/**
 *
 * @link http://stackoverflow.com/questions/24573028/dropwizard-custom-exception-for-invalidentityexception
 */
@Provider
public class BusinessLogicExceptionMapper implements ExceptionMapper<BusinessLogicException> {

    /**
     * Builds a response.
     *
     * @param ex
     * @return
     */
    @Override
    public Response toResponse(BusinessLogicException ex) {
        LoggerFactory.getLogger(BusinessLogicException.class).info(ex.getMessage());
        return Response.status(ex.getStatus())
                .entity(new BasicResponse(ex))
                .type("text/json")
                .build();
    }
}
