/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.UUID;
import net.leanix.dropkit.oauth.models.PermissionRole;
import net.leanix.dropkit.oauth.models.PermissionStatus;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID id;
    private UUID workspaceId;
    private PermissionRole role;
    private PermissionStatus status = PermissionStatus.ACTIVE;

    public void setId(UUID id) {
        this.id = id;
    }

    @ApiModelProperty(dataType="string")
    public UUID getId() {
        return this.id;
    }

    @ApiModelProperty(dataType="string")
    public UUID getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
    }

    @ApiModelProperty(dataType="string")
    public PermissionStatus getStatus() {
        return this.status;
    }

    public void setStatus(PermissionStatus status) {
        this.status = status;
    }

    @JsonIgnore
    public boolean isActive() {
        return PermissionStatus.ACTIVE.equals((Object)this.status);
    }

    @JsonIgnore
    public boolean isActive(PermissionRole role) {
        return this.isActive() && this.hasRole(role);
    }

    @ApiModelProperty(dataType="string")
    public PermissionRole getRole() {
        return this.role;
    }

    public void setRole(PermissionRole role) {
        this.role = role;
    }

    public boolean hasRole(PermissionRole role) {
        return this.role != null && this.role.equals((Object)role);
    }

    public String toString() {
        return "[Permission: Workspace " + this.workspaceId + ", role " + (Object)((Object)this.role) + ", status " + this.status.toString() + "]";
    }
}

