/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.nio.charset.Charset;
import net.leanix.dropkit.amqp.ConsumerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueueConsumer
extends DefaultConsumer {
    private final Logger log = LoggerFactory.getLogger(QueueConsumer.class);
    private final String queueName;
    private final ConsumerRegistry registry;
    private String registeredConsumerTag;
    private volatile boolean unregistering = false;
    private volatile long lastUsed;
    private final Charset utf8 = Charset.forName("UTF-8");

    public QueueConsumer(String queueName, Channel channel, ConsumerRegistry registry) {
        super(channel);
        this.queueName = queueName;
        this.registry = registry;
        this.lastUsed = System.currentTimeMillis();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getRegisteredConsumerTag() {
        return this.registeredConsumerTag;
    }

    public void setRegisteredConsumerTag(String consumerTag) {
        this.registeredConsumerTag = consumerTag;
    }

    public void setUnregistering() {
        this.unregistering = true;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void handleDelivery(String consumerTag, Envelope env, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.log.debug("received message {} from queue {}", (Object)props.getMessageId(), (Object)this.queueName);
        this.lastUsed = System.currentTimeMillis();
        String stringBody = new String(body, this.utf8);
        this.simpleHandle(stringBody);
        this.getChannel().basicAck(env.getDeliveryTag(), false);
    }

    public abstract void simpleHandle(String var1) throws IOException;

    public void handleConsumeOk(String consumerTag) {
        this.log.info("consumer started consuming for queue {}, consumerTag={}", (Object)this.queueName, (Object)consumerTag);
    }

    public void handleCancelOk(String consumerTag) {
        this.log.info("consumer for queue {}, consumerTag={}, was regularly cancelled. unregister it.", (Object)this.queueName, (Object)consumerTag);
        if (!this.unregistering) {
            this.unregistering = true;
            this.registry.unregister(this);
        }
    }

    public void handleCancel(String consumerTag) {
        this.log.info("consumer for queue {}, consumerTag={}, was cancelled, e.g. because queue was deleted. unregister it.", (Object)this.queueName, (Object)consumerTag);
        if (!this.unregistering) {
            this.unregistering = true;
            this.registry.unregister(this);
        }
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException e) {
        this.log.info("{} for consumer for queue {}, consumerTag={}, was closed. unregister consumer.", new Object[]{e.isHardError() ? "connection" : "channel", this.queueName, consumerTag});
        if (!this.unregistering) {
            this.unregistering = true;
            this.registry.unregister(this);
        }
    }
}

