/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util.testenvironments;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.leanix.dropkit.util.DockerEnvironment;
import net.leanix.dropkit.util.NetworkUtils;
import net.leanix.dropkit.util.ProcessWrapper;
import net.leanix.dropkit.util.testenvironments.ElasticSearchFacade;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchEnvironment
extends DockerEnvironment {
    private static final String IMAGE_NAME = "elasticsearch:1.6";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchEnvironment.class);
    public static final String USERNAME = "guest";
    public static final String PASSWORD = "guest";
    public static final int PORT = 9200;
    private final int elasticSearchPort;
    private ElasticSearchFacade elasticSearchFacade;
    private String containerName;
    private String portmappingElastic;
    private final String clusterName;

    public ElasticSearchEnvironment() {
        this(9200, null);
    }

    public ElasticSearchEnvironment(String clusterName) {
        this(9200, clusterName);
    }

    public ElasticSearchEnvironment(int port, String clusterName) {
        this.elasticSearchPort = NetworkUtils.findFirstPort(this.BOOT2DOCKER_IP, port, port + 10, false);
        this.portmappingElastic = StringUtils.isEmpty((CharSequence)this.BOOT2DOCKER_IP) ? this.elasticSearchPort + ":" + 9200 : this.BOOT2DOCKER_IP + ":" + this.elasticSearchPort + ":" + 9200;
        this.containerName = "junit-elasticSearch";
        this.clusterName = StringUtils.isNotEmpty((CharSequence)clusterName) ? clusterName : "leanix_elastic";
    }

    protected void before() throws Throwable {
        this.runDockerCmd("rm", "-f", this.containerName);
        final CountDownLatch dbIsRunning = new CountDownLatch(1);
        ProcessBuilder pb = new ProcessBuilder(this.dockerProgram.getPath(), "run", "-i", "--name", this.containerName, "-p", this.portmappingElastic, "-e", "ES_MIN_MEM=64m", "-e", "ES_MAX_MEM=128m", "-e", "ES_JAVA_OPTS=-Des.cluster.name=" + this.clusterName, IMAGE_NAME);
        Map<String, String> environment = pb.environment();
        environment.putAll(this.bashEnv);
        this.processWrapper = new ProcessWrapper(pb);
        try {
            this.processWrapper.start(new ProcessWrapper.StdXXXLineListener(){

                public boolean fireNewLine(String line) {
                    System.out.println(line);
                    if (line.contains("started")) {
                        dbIsRunning.countDown();
                    }
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("RabbitMQ cound not be started.");
            return;
        }
        dbIsRunning.await(20L, TimeUnit.SECONDS);
        long count = dbIsRunning.getCount();
        if (count > 0L) {
            LOG.warn("Elastic Search seems not to be started correctly.");
        }
        this.elasticSearchFacade = new ElasticSearchFacade(this.containerName, this.BOOT2DOCKER_IP, this.elasticSearchPort);
        LOG.info(String.format("Elastic api : http://%s:%d", this.BOOT2DOCKER_IP, 9200));
        super.before();
    }

    @Override
    protected void after() {
        if (this.elasticSearchFacade != null) {
            this.elasticSearchFacade.close();
        }
        super.after();
        this.runDockerCmd("rm", "-f", this.containerName);
    }

    public ElasticSearchFacade getElasticSearchFacade() {
        return this.elasticSearchFacade;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

