/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.amqp.testsupport;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.leanix.dropkit.amqp.testsupport.RabbitMQFacade;
import net.leanix.dropkit.util.DockerEnvironment;
import net.leanix.dropkit.util.NetworkUtils;
import net.leanix.dropkit.util.ProcessWrapper;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQEnvironment
extends DockerEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQEnvironment.class);
    public static final String USERNAME = "guest";
    public static final String PASSWORD = "guest";
    public static final int PORT = 5672;
    public static final int HTTP_PORT = 8082;
    private final int freeSocketPort;
    private final File rabbitMQDataPath = new File("target/it-rabbitmq/");
    private RabbitMQFacade rabbitMQFacade;
    private String containerName;
    private String portmappingRabbit;
    private String portmappingHttp;

    public RabbitMQEnvironment() {
        this(NetworkUtils.findFreeSocket(25672, 25682));
    }

    public RabbitMQEnvironment(int port) {
        this.freeSocketPort = port;
        if (StringUtils.isEmpty((CharSequence)this.BOOT2DOCKER_IP)) {
            this.portmappingRabbit = this.freeSocketPort + ":" + 5672;
            this.portmappingHttp = "8082:15672";
        } else {
            this.portmappingRabbit = this.BOOT2DOCKER_IP + ":" + this.freeSocketPort + ":" + 5672;
            this.portmappingHttp = this.BOOT2DOCKER_IP + ":" + 8082 + ":15672";
        }
        this.containerName = "junit-rabbit";
    }

    protected void before() throws Throwable {
        if (!this.rabbitMQDataPath.exists()) {
            FileUtils.forceMkdir((File)this.rabbitMQDataPath);
        }
        this.runDockerCmd("rm", "-f", this.containerName);
        final CountDownLatch dbIsRunning = new CountDownLatch(1);
        ProcessBuilder pb = new ProcessBuilder(this.dockerProgram.getPath(), "run", "-i", "--hostname", "junit-rabbit-host", "--name", this.containerName, "-p", this.portmappingRabbit, "-p", this.portmappingHttp, "-e", "RABBITMQ_DEFAULT_USER=guest", "-e", "RABBITMQ_DEFAULT_PASSguest", "rabbitmq:3-management");
        Map<String, String> environment = pb.environment();
        environment.putAll(this.bashEnv);
        this.processWrapper = new ProcessWrapper(pb);
        try {
            this.processWrapper.start(new ProcessWrapper.StdXXXLineListener(){

                public boolean fireNewLine(String line) {
                    System.out.println(line);
                    if (line.contains("Server startup complete;")) {
                        dbIsRunning.countDown();
                    }
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("RabbitMQ cound not be started.");
            return;
        }
        dbIsRunning.await(20L, TimeUnit.SECONDS);
        long count = dbIsRunning.getCount();
        if (count > 0L) {
            LOG.warn("RabbitMQ seems not to be started correctly.");
        }
        this.rabbitMQFacade = new RabbitMQFacade(this.containerName, this.BOOT2DOCKER_IP, this.freeSocketPort);
        LOG.info(String.format("RabbitMQ admin  : %s", "http://192.168.59.103:8082"));
        LOG.info(String.format("RabbitMQ server : amqp://%s@%s:%d/", "guest", this.BOOT2DOCKER_IP, this.freeSocketPort));
        super.before();
    }

    @Override
    protected void after() {
        if (this.rabbitMQFacade != null) {
            this.rabbitMQFacade.close();
        }
        super.after();
        this.runDockerCmd("rm", "-f", this.containerName);
    }

    public RabbitMQFacade getRabbitMQFacade() {
        return this.rabbitMQFacade;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)((Object)this), (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

