package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.leanix.dropkit.oauth.token.KeyReaderRSA;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;

import java.security.Key;


public class OAuth2AuthServerConfig implements OAuth2TokenConfig {

    @JsonProperty
    private String privateKeyPath;

    public String getPrivateKeyPath() {
        return privateKeyPath;
    }

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    @Override
    @JsonIgnore
    public Key getSigningKey() throws Exception {
        if (this.privateKeyPath == null)
            throw new Exception("SigningKeyPath must be set");

        return KeyReaderRSA.getPrivateKey(privateKeyPath);
    }
}
