/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import net.leanix.dropkit.etcd.EtcdException;
import net.leanix.dropkit.etcd.MinimalEtcdClient;
import net.leanix.dropkit.etcd.MinimalEtcdClientFactory;
import net.leanix.dropkit.util.DeploymentColor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentUtil.class);
    static String ROOT_VHOSTS = "/vhosts/";
    public static final String VIRTUAL_HOST = "VIRTUAL_HOST";
    public static final String CONTAINER_COLOR = "CONTAINER_COLOR";
    public static final String ETCD_SERVER = "ETCD_SERVER";
    private final MinimalEtcdClient etcdClient;
    private final DeploymentColor containerColor;

    public DeploymentUtil(MinimalEtcdClientFactory etcdClientFactory) {
        URI etcdUri;
        String color = this.getEnvironmentVariable(CONTAINER_COLOR);
        this.containerColor = DeploymentColor.fromString(color);
        LOG.debug("Detected assigned deployment color '{}' for this container.", (Object)this.containerColor);
        String etcdServer = this.getEnvironmentVariable(ETCD_SERVER);
        if (StringUtils.isEmpty((CharSequence)etcdServer)) {
            LOG.debug("No etcd server configuration detected. Is this container running in an on premise environment? ETCD configuration will be skipped.");
            etcdUri = null;
        } else {
            etcdUri = URI.create(String.format("http://%s", etcdServer));
        }
        this.etcdClient = etcdClientFactory.create(etcdUri);
    }

    public DeploymentUtil() {
        this(new MinimalEtcdClientFactory());
    }

    public DeploymentColor getContainerColor() {
        return this.containerColor;
    }

    public DeploymentColor getContainerColorOrDefault(DeploymentColor defaultColor) {
        Preconditions.checkNotNull((Object)((Object)defaultColor), (Object)"defaultColor must not be null");
        return this.getContainerColor() != null ? this.getContainerColor() : defaultColor;
    }

    public boolean isInstanceCurrentlyActive() {
        if (this.containerColor == null) {
            LOG.warn("Can not detect container color and return: NO - this container is not currently active.");
            return false;
        }
        if (this.containerColor == DeploymentColor.WHITE) {
            return true;
        }
        if (this.etcdClient.getEtcdUri() == null) {
            if (this.containerColor != DeploymentColor.WHITE) {
                LOG.warn("Although the container color '{}' is specified, no environment variable '{}' exists to specify the etcd configuration.", (Object)this.containerColor, (Object)ETCD_SERVER);
            }
            return true;
        }
        try {
            String currentColor = this.retrieveEtcdValue("deploy_current");
            LOG.debug("Read current deployment color '{}' from etcd. This container has color {}.", (Object)currentColor, (Object)this.containerColor);
            return this.containerColor.toString().equalsIgnoreCase(currentColor);
        }
        catch (EtcdException e) {
            LOG.warn("Problem accessing etcd (URL is '{}')", (Object)this.etcdClient.getEtcdUri(), (Object)e);
            return false;
        }
    }

    private String getEnvironmentVariable(String varName) {
        String env = System.getenv(varName);
        if (env == null) {
            LOG.debug("Environment variable '{}' not found in Sytem.env(). Try to read from System.properties.", (Object)varName);
            return System.getProperty(varName);
        }
        return env;
    }

    public String retrieveEtcdValue(String key) throws EtcdException {
        String completeKey = this.buildKeyForVirtualHost(key);
        String value = this.etcdClient.get(completeKey);
        LOG.debug("Retrieved value '{}' under key '{}' from etcd. (URL: {})", new Object[]{value, completeKey, this.etcdClient.getEtcdUri()});
        return value;
    }

    public void writeEtcdValue(String key, String value) throws EtcdException {
        String completeKey = this.buildKeyForVirtualHost(key);
        this.etcdClient.set(completeKey, value);
        LOG.debug("Set value '{}' under key '{}' in etcd. (URL: {})", new Object[]{value, completeKey, this.etcdClient.getEtcdUri()});
    }

    private String buildKeyForVirtualHost(String key) {
        String virtualHost = this.getEnvironmentVariable(VIRTUAL_HOST);
        if (StringUtils.isEmpty((CharSequence)virtualHost)) {
            virtualHost = "local-svc.leanix.net";
            LOG.warn("Environment variable '{}' not found. Using '{}' as default.", (Object)VIRTUAL_HOST, (Object)virtualHost);
        }
        String completeKey = ROOT_VHOSTS + virtualHost.trim() + '/' + key;
        return completeKey;
    }

    public boolean isEtcdConfigured() {
        return this.etcdClient.getEtcdUri() != null;
    }
}

