/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.leanix.dropkit.util.TimeoutExecutor;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessWrapper.class);
    private final ProcessBuilder _processBuilder;
    private Process _process;
    private Thread stdOutListenerThread;

    public ProcessWrapper(ProcessBuilder processBuilder) {
        this._processBuilder = processBuilder;
    }

    public ProcessWrapper start(final StdXXXLineListener newStdOutLineListener) throws IOException {
        this._processBuilder.redirectErrorStream(true);
        LOG.info("Start external Process: {}", (Object)StringUtils.join(this._processBuilder.command(), (String)" "));
        this._process = this._processBuilder.start();
        if (newStdOutLineListener != null) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(ProcessWrapper.this._process.getInputStream()));
                    try {
                        try {
                            boolean needMoreLines;
                            String line;
                            while ((line = stdOutReader.readLine()) != null && (needMoreLines = newStdOutLineListener.fireNewLine(line))) {
                            }
                            LOG.debug("stdout stream is dead so termitate stdout listener thread clearly.");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)stdOutReader);
                    }
                }
            };
            this.stdOutListenerThread = new Thread(runnable);
            this.stdOutListenerThread.start();
        }
        return this;
    }

    public boolean isRunning() {
        if (this._process == null) {
            return false;
        }
        try {
            this._process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public boolean waitUntilFinished(int timeOut, TimeUnit timeUnit) {
        long timeOutInMillis = System.currentTimeMillis() + timeUnit.toMillis(timeOut);
        while (this.isRunning()) {
            if (timeOutInMillis <= System.currentTimeMillis()) {
                return false;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                this.destroy();
            }
        }
        return true;
    }

    public int getExitValue() {
        try {
            this._process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this._process.exitValue();
    }

    public void destroy() {
        int pid = this.getUnixPID(this._process);
        this.executeCommand("kill", "" + pid);
        new TimeoutExecutor(5000L, 10L).checkUntilConditionIsTrue(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean running = ProcessWrapper.this.isRunning();
                return !running;
            }
        });
        if (this.isRunning()) {
            this.executeCommand("kill", "-9", "" + pid);
            new TimeoutExecutor(5000L, 10L).checkUntilConditionIsTrue(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return !ProcessWrapper.this.isRunning();
                }
            });
        }
        this._process.destroy();
        if (this.stdOutListenerThread != null) {
            this.stdOutListenerThread.interrupt();
        }
    }

    private void executeCommand(String ... cmd) {
        ProcessBuilder pBuilder = new ProcessBuilder(cmd);
        try {
            LOG.debug("start command '" + Arrays.asList(cmd) + "'");
            Process myProcess = pBuilder.start();
            IOUtils.closeQuietly((OutputStream)myProcess.getOutputStream());
            IOUtils.closeQuietly((InputStream)myProcess.getInputStream());
            IOUtils.closeQuietly((InputStream)myProcess.getErrorStream());
        }
        catch (IOException e) {
            LOG.warn("Can not execute " + Arrays.asList(cmd), (Throwable)e);
            return;
        }
    }

    private Integer getUnixPID(Process process) {
        if (process.getClass().getName().equals("java.lang.UNIXProcess")) {
            try {
                Class<?> cl = process.getClass();
                Field field = cl.getDeclaredField("pid");
                field.setAccessible(true);
                Object pidObject = field.get(process);
                return (Integer)pidObject;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Needs to be a UNIXProcess");
    }

    public int waitFor() throws InterruptedException {
        return this._process.waitFor();
    }

    public static abstract class StdXXXLineListener {
        public abstract boolean fireNewLine(String var1);
    }
}

