/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.leanix.dropkit.BusinessLogicException;
import net.leanix.dropkit.api.ApiError;
import net.leanix.dropkit.responses.ResponseStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BasicResponse {
    protected ResponseStatus status = ResponseStatus.OK;
    protected String type;
    protected String message;
    protected List<ApiError> errors = new ArrayList<ApiError>();
    protected Long total;

    public BasicResponse() {
        this.status = ResponseStatus.OK;
    }

    public BasicResponse(ConstraintViolationException ex) {
        this.status = ResponseStatus.ERROR;
        this.type = ex.getClass().getSimpleName();
        this.message = ex.getMessage();
        if (ex.getConstraintViolations().isEmpty()) {
            this.appendToErrors("error", ex.getMessage());
        } else {
            for (ConstraintViolation violation : ex.getConstraintViolations()) {
                this.appendToErrors(violation.getPropertyPath().toString(), violation.getMessage());
            }
        }
    }

    public BasicResponse(BusinessLogicException ex) {
        this.status = ResponseStatus.ERROR;
        this.type = ex.getClass().getSimpleName();
        if (ex.namesSpecificProperty()) {
            this.message = "error for property";
            this.appendToErrors(ex.getPropertyName(), ex.getMessage());
        } else {
            this.message = ex.getMessage();
            this.appendToErrors("error", ex.getMessage());
        }
    }

    @ApiModelProperty(dataType="string")
    public ResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public List<ApiError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ApiError> errors) {
        this.errors = errors;
    }

    public Long getTotal() {
        if (this.total == null) {
            return 0L;
        }
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    private void appendToErrors(String key, String message) {
        ApiError error = this.getError(key);
        if (error == null) {
            error = new ApiError(key, new ArrayList());
            this.errors.add(error);
        }
        error.getMessages().add(message);
    }

    @JsonIgnore
    public ApiError getError(String field) {
        for (ApiError e : this.errors) {
            if (e.getValue() == null || !e.getValue().equals(field)) continue;
            return e;
        }
        return null;
    }
}

