/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.leanix.dropkit.util.ProcessWrapper;
import net.leanix.dropkit.util.SearchPathUtil;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerEnvironment
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(DockerEnvironment.class);
    public String BOOT2DOCKER_IP;
    protected final File dockerProgram;
    protected ProcessWrapper processWrapper;
    protected Map<String, String> bashEnv;

    public DockerEnvironment() {
        block5: {
            this.bashEnv = new HashMap<String, String>();
            String programName = null;
            this.bashEnv.put("PATH", "/usr/local/bin:/usr/bin:/bin:/usr/sbin:/sbin");
            try {
                programName = SearchPathUtil.findPath((String[])new String[]{"/usr/local/bin/docker", "/usr/bin/docker"});
            }
            catch (IllegalArgumentException e) {
                LOG.info("Can not find executable for docker in test pathes.");
            }
            if (StringUtils.isEmpty(programName)) {
                programName = "docker";
            }
            this.dockerProgram = new File(programName);
            try {
                this.runDockerWithParams("ps");
                System.out.println("docker is installed directly");
                this.BOOT2DOCKER_IP = "localhost";
            }
            catch (Exception e) {
                String boot2dockerHost = this.execCommand("/usr/local/bin/boot2docker", "ip");
                if (boot2dockerHost == null || !boot2dockerHost.matches("[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+")) break block5;
                LOG.info("detected boot2docker with host {}", (Object)boot2dockerHost);
                this.BOOT2DOCKER_IP = URI.create(boot2dockerHost).toString();
                this.bashEnv.put("DOCKER_HOST", "tcp://" + this.BOOT2DOCKER_IP + ":2376");
                this.bashEnv.put("DOCKER_CERT_PATH", System.getProperty("user.home") + "/.boot2docker/certs/boot2docker-vm");
                this.bashEnv.put("DOCKER_TLS_VERIFY", "1");
            }
        }
    }

    protected void after() {
        if (this.processWrapper != null && this.processWrapper.isRunning()) {
            this.processWrapper.destroy();
        }
        super.after();
    }

    protected void runDockerCmd(String ... params) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(this.dockerProgram.getPath());
        cmds.addAll(Arrays.asList(params));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        Map<String, String> environment = pb.environment();
        environment.putAll(this.bashEnv);
        try {
            ProcessWrapper pw = new ProcessWrapper(pb).start(null);
            pw.waitUntilFinished(10, TimeUnit.SECONDS);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String runDockerWithParams(String ... params) throws InterruptedException {
        ProcessWrapper start;
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(this.dockerProgram.getPath());
        cmds.addAll(Arrays.asList(params));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        this.processWrapper = new ProcessWrapper(pb);
        final CountDownLatch versionLatch = new CountDownLatch(1);
        final StringBuilder sb = new StringBuilder();
        try {
            start = this.processWrapper.start(new ProcessWrapper.StdXXXLineListener(){

                public boolean fireNewLine(String line) {
                    System.out.println(line);
                    sb.append(line);
                    versionLatch.countDown();
                    return true;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("RabbitMQ cound not be started.");
            return null;
        }
        versionLatch.await(30L, TimeUnit.SECONDS);
        if (start != null && start.getExitValue() != 0) {
            throw new RuntimeException("Process ended with exit value " + start.getExitValue());
        }
        return sb.toString();
    }

    protected String execCommand(String cmd, String ... params) {
        ProcessWrapper start;
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(cmd);
        cmds.addAll(Arrays.asList(params));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        this.processWrapper = new ProcessWrapper(pb);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final StringBuilder sb = new StringBuilder();
        Map<String, String> environment = pb.environment();
        environment.putAll(this.bashEnv);
        try {
            start = this.processWrapper.start(new ProcessWrapper.StdXXXLineListener(){

                public boolean fireNewLine(String line) {
                    System.out.println(line);
                    sb.append(line);
                    countDownLatch.countDown();
                    return true;
                }
            });
            countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("{} can not be started", (Object)cmd, (Object)e);
            return null;
        }
        if (start != null && start.getExitValue() != 0) {
            throw new RuntimeException("Process ended with exit value " + start.getExitValue());
        }
        return sb.toString();
    }
}

