package net.leanix.dropkit;

import javax.ws.rs.core.Response;

/**
 * An exception to be throw when business logic is violated.
 *
 * The exception can be specific for an entity property. In this case the name
 * of the property can be retrieved and used in json result responses.
 */
public class BusinessLogicException extends Exception {

    private String propertyName;
    private int status = 422;

    public BusinessLogicException(String msg) {
        super(msg);
    }

    /**
     * Uses this for json error message with a defined response status.
     *
     * @param msg
     * @param status
     */
    public BusinessLogicException(String msg, int status) {
        super(msg);
        this.status = status;
    }

    public BusinessLogicException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public BusinessLogicException(String propertyName, String msg) {
        super(msg);
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public boolean namesSpecificProperty() {
        return propertyName != null;
    }

    public int getStatus() {
        return status;
    }
}
