/*
 * Decompiled with CFR 0.152.
 */
package net.leanix.dropkit.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import net.leanix.dropkit.oauth.models.Principal;
import net.leanix.dropkit.oauth.token.OAuth2Token;
import net.leanix.dropkit.oauth.token.OAuth2TokenConfig;
import net.leanix.dropkit.oauth.token.OAuth2TokenParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Authenticator
implements Authenticator<String, Principal> {
    private final Logger logger = LoggerFactory.getLogger(OAuth2Authenticator.class);
    private final OAuth2TokenParser parser;
    private static final ObjectMapper mapper = new ObjectMapper();

    @Inject
    public OAuth2Authenticator(OAuth2TokenConfig config) throws Exception {
        this.parser = new OAuth2TokenParser(config);
    }

    public Optional<Principal> authenticate(String accessToken) throws AuthenticationException {
        if (accessToken == null) {
            this.logger.warn("No token provided");
            return Optional.absent();
        }
        try {
            OAuth2Token token = this.parser.parse(accessToken);
            return Optional.fromNullable((Object)token.getPrincipal());
        }
        catch (ExpiredJwtException ex) {
            this.logger.warn("Token expired, token = " + accessToken.substring(0, 10) + "...");
            return Optional.absent();
        }
        catch (JwtException ex) {
            this.logger.warn("Unable to verify, token = " + accessToken.substring(0, 10) + "...", (Throwable)ex);
            return Optional.absent();
        }
        catch (Throwable ex) {
            throw new AuthenticationException("Unable to authenticate, token = " + accessToken.substring(0, 10) + "...", ex);
        }
    }

    static {
        mapper.disableDefaultTyping();
    }
}

